import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";

import { BASE_API_URL_STG } from "@env";
import { queryResponse } from "../../util/processResponse.js";

const URL = `${BASE_API_URL_STG}/user/addresses`;

const initialState = {
    myAddresses: [],
    defaultAddress: {},
    loading: false,
    isRefresh: false,
    nextPageUrl: "",
    loadMore: false,
};

export const getMyAddress = createAsyncThunk(
    "user/getMyAddress",
    async (access_token) => {
        const response = await queryResponse(URL, "GET", access_token);
        return response;
    }
);
export const getMoreAddress = createAsyncThunk(
    "user/getMoreAddress",
    async ({access_token, URL}) => {
        const response = await queryResponse(URL, "GET", access_token);
        return response;
    }
);

const getMyAddressSlice = createSlice({
    name: "user",
    initialState,
    reducers: {
        resetAddress: (state) => {
            state.myAddresses = [];
            (state.defaultAddress = {}), (state.isRefresh = false);
            state.loading = false;
        },
        fetchAddressStart: (state) => {
            state.isRefresh = true;
        },
        getMyAddressWithoutLoading: (state, { payload }) => {
            const defaultAddress = payload?.find((item) => item.is_default);
            state.defaultAddress = defaultAddress ?? {};
            state.myAddresses = payload;
            state.loading = false;
            state.isRefresh = false;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getMyAddress.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getMyAddress.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records: {pagination, data} = {} } = payload || {};
            if (code === 200) {
                const defaultAddress = data?.find(
                    (item) => item.is_default
                );
                state.defaultAddress = defaultAddress ?? {};
                state.myAddresses = data;
                state.nextPageUrl = pagination?.next_page_url;
            }
            state.loading = false;
        });
        builder.addCase(getMyAddress.rejected, (state) => {
            state.loading = false;
        });
        
        builder.addCase(getMoreAddress.pending, (state) => {
            state.loadMore = true;
        });
        builder.addCase(getMoreAddress.fulfilled, (state, { payload }) => {
            const {
                status: { code } = {},
                records: { pagination, data } = {},
            } = payload || {};
            if (code === 200) {
                state.myAddresses = [...state.myAddresses, ...data];
                state.nextPageUrl = pagination?.next_page_url;
            }
            state.loadMore = false;
        });
        builder.addCase(getMoreAddress.rejected, (state) => {
            state.loadMore = false;
        });
    },
});

export const { resetAddress, fetchAddressStart, getMyAddressWithoutLoading } =
    getMyAddressSlice.actions;

export default getMyAddressSlice.reducer;
